<?php

namespace Filament\Support\Icons;

use Filament\Support\Contracts\ScalableIcon;
use Filament\Support\Enums\IconSize;

enum Heroicon: string implements ScalableIcon
{
    case AcademicCap = 'academic-cap';
    case AdjustmentsHorizontal = 'adjustments-horizontal';
    case AdjustmentsVertical = 'adjustments-vertical';
    case ArchiveBoxArrowDown = 'archive-box-arrow-down';
    case ArchiveBoxXMark = 'archive-box-x-mark';
    case ArchiveBox = 'archive-box';
    case ArrowDownCircle = 'arrow-down-circle';
    case ArrowDownLeft = 'arrow-down-left';
    case ArrowDownOnSquareStack = 'arrow-down-on-square-stack';
    case ArrowDownOnSquare = 'arrow-down-on-square';
    case ArrowDownRight = 'arrow-down-right';
    case ArrowDownTray = 'arrow-down-tray';
    case ArrowDown = 'arrow-down';
    case ArrowLeftCircle = 'arrow-left-circle';
    case ArrowLeftEndOnRectangle = 'arrow-left-end-on-rectangle';
    case ArrowLeftOnRectangle = 'arrow-left-on-rectangle';
    case ArrowLeftStartOnRectangle = 'arrow-left-start-on-rectangle';
    case ArrowLeft = 'arrow-left';
    case ArrowLongDown = 'arrow-long-down';
    case ArrowLongLeft = 'arrow-long-left';
    case ArrowLongRight = 'arrow-long-right';
    case ArrowLongUp = 'arrow-long-up';
    case ArrowPathRoundedSquare = 'arrow-path-rounded-square';
    case ArrowPath = 'arrow-path';
    case ArrowRightCircle = 'arrow-right-circle';
    case ArrowRightEndOnRectangle = 'arrow-right-end-on-rectangle';
    case ArrowRightOnRectangle = 'arrow-right-on-rectangle';
    case ArrowRightStartOnRectangle = 'arrow-right-start-on-rectangle';
    case ArrowRight = 'arrow-right';
    case ArrowSmallDown = 'arrow-small-down';
    case ArrowSmallLeft = 'arrow-small-left';
    case ArrowSmallRight = 'arrow-small-right';
    case ArrowSmallUp = 'arrow-small-up';
    case ArrowTopRightOnSquare = 'arrow-top-right-on-square';
    case ArrowTrendingDown = 'arrow-trending-down';
    case ArrowTrendingUp = 'arrow-trending-up';
    case ArrowTurnDownLeft = 'arrow-turn-down-left';
    case ArrowTurnDownRight = 'arrow-turn-down-right';
    case ArrowTurnLeftDown = 'arrow-turn-left-down';
    case ArrowTurnLeftUp = 'arrow-turn-left-up';
    case ArrowTurnRightDown = 'arrow-turn-right-down';
    case ArrowTurnRightUp = 'arrow-turn-right-up';
    case ArrowTurnUpLeft = 'arrow-turn-up-left';
    case ArrowTurnUpRight = 'arrow-turn-up-right';
    case ArrowUpCircle = 'arrow-up-circle';
    case ArrowUpLeft = 'arrow-up-left';
    case ArrowUpOnSquareStack = 'arrow-up-on-square-stack';
    case ArrowUpOnSquare = 'arrow-up-on-square';
    case ArrowUpRight = 'arrow-up-right';
    case ArrowUpTray = 'arrow-up-tray';
    case ArrowUp = 'arrow-up';
    case ArrowUturnDown = 'arrow-uturn-down';
    case ArrowUturnLeft = 'arrow-uturn-left';
    case ArrowUturnRight = 'arrow-uturn-right';
    case ArrowUturnUp = 'arrow-uturn-up';
    case ArrowsPointingIn = 'arrows-pointing-in';
    case ArrowsPointingOut = 'arrows-pointing-out';
    case ArrowsRightLeft = 'arrows-right-left';
    case ArrowsUpDown = 'arrows-up-down';
    case AtSymbol = 'at-symbol';
    case Backspace = 'backspace';
    case Backward = 'backward';
    case Banknotes = 'banknotes';
    case Bars2 = 'bars-2';
    case Bars3BottomLeft = 'bars-3-bottom-left';
    case Bars3BottomRight = 'bars-3-bottom-right';
    case Bars3CenterLeft = 'bars-3-center-left';
    case Bars3 = 'bars-3';
    case Bars4 = 'bars-4';
    case BarsArrowDown = 'bars-arrow-down';
    case BarsArrowUp = 'bars-arrow-up';
    case Battery0 = 'battery-0';
    case Battery100 = 'battery-100';
    case Battery50 = 'battery-50';
    case Beaker = 'beaker';
    case BellAlert = 'bell-alert';
    case BellSlash = 'bell-slash';
    case BellSnooze = 'bell-snooze';
    case Bell = 'bell';
    case Bold = 'bold';
    case BoltSlash = 'bolt-slash';
    case Bolt = 'bolt';
    case BookOpen = 'book-open';
    case BookmarkSlash = 'bookmark-slash';
    case BookmarkSquare = 'bookmark-square';
    case Bookmark = 'bookmark';
    case Briefcase = 'briefcase';
    case BugAnt = 'bug-ant';
    case BuildingLibrary = 'building-library';
    case BuildingOffice2 = 'building-office-2';
    case BuildingOffice = 'building-office';
    case BuildingStorefront = 'building-storefront';
    case Cake = 'cake';
    case Calculator = 'calculator';
    case CalendarDateRange = 'calendar-date-range';
    case CalendarDays = 'calendar-days';
    case Calendar = 'calendar';
    case Camera = 'camera';
    case ChartBarSquare = 'chart-bar-square';
    case ChartBar = 'chart-bar';
    case ChartPie = 'chart-pie';
    case ChatBubbleBottomCenterText = 'chat-bubble-bottom-center-text';
    case ChatBubbleBottomCenter = 'chat-bubble-bottom-center';
    case ChatBubbleLeftEllipsis = 'chat-bubble-left-ellipsis';
    case ChatBubbleLeftRight = 'chat-bubble-left-right';
    case ChatBubbleLeft = 'chat-bubble-left';
    case ChatBubbleOvalLeftEllipsis = 'chat-bubble-oval-left-ellipsis';
    case ChatBubbleOvalLeft = 'chat-bubble-oval-left';
    case CheckBadge = 'check-badge';
    case CheckCircle = 'check-circle';
    case Check = 'check';
    case ChevronDoubleDown = 'chevron-double-down';
    case ChevronDoubleLeft = 'chevron-double-left';
    case ChevronDoubleRight = 'chevron-double-right';
    case ChevronDoubleUp = 'chevron-double-up';
    case ChevronDown = 'chevron-down';
    case ChevronLeft = 'chevron-left';
    case ChevronRight = 'chevron-right';
    case ChevronUpDown = 'chevron-up-down';
    case ChevronUp = 'chevron-up';
    case CircleStack = 'circle-stack';
    case ClipboardDocumentCheck = 'clipboard-document-check';
    case ClipboardDocumentList = 'clipboard-document-list';
    case ClipboardDocument = 'clipboard-document';
    case Clipboard = 'clipboard';
    case Clock = 'clock';
    case CloudArrowDown = 'cloud-arrow-down';
    case CloudArrowUp = 'cloud-arrow-up';
    case Cloud = 'cloud';
    case CodeBracketSquare = 'code-bracket-square';
    case CodeBracket = 'code-bracket';
    case Cog6Tooth = 'cog-6-tooth';
    case Cog8Tooth = 'cog-8-tooth';
    case Cog = 'cog';
    case CommandLine = 'command-line';
    case ComputerDesktop = 'computer-desktop';
    case CpuChip = 'cpu-chip';
    case CreditCard = 'credit-card';
    case CubeTransparent = 'cube-transparent';
    case Cube = 'cube';
    case CurrencyBangladeshi = 'currency-bangladeshi';
    case CurrencyDollar = 'currency-dollar';
    case CurrencyEuro = 'currency-euro';
    case CurrencyPound = 'currency-pound';
    case CurrencyRupee = 'currency-rupee';
    case CurrencyYen = 'currency-yen';
    case CursorArrowRays = 'cursor-arrow-rays';
    case CursorArrowRipple = 'cursor-arrow-ripple';
    case DevicePhoneMobile = 'device-phone-mobile';
    case DeviceTablet = 'device-tablet';
    case Divide = 'divide';
    case DocumentArrowDown = 'document-arrow-down';
    case DocumentArrowUp = 'document-arrow-up';
    case DocumentChartBar = 'document-chart-bar';
    case DocumentCheck = 'document-check';
    case DocumentCurrencyBangladeshi = 'document-currency-bangladeshi';
    case DocumentCurrencyDollar = 'document-currency-dollar';
    case DocumentCurrencyEuro = 'document-currency-euro';
    case DocumentCurrencyPound = 'document-currency-pound';
    case DocumentCurrencyRupee = 'document-currency-rupee';
    case DocumentCurrencyYen = 'document-currency-yen';
    case DocumentDuplicate = 'document-duplicate';
    case DocumentMagnifyingGlass = 'document-magnifying-glass';
    case DocumentMinus = 'document-minus';
    case DocumentPlus = 'document-plus';
    case DocumentText = 'document-text';
    case Document = 'document';
    case EllipsisHorizontalCircle = 'ellipsis-horizontal-circle';
    case EllipsisHorizontal = 'ellipsis-horizontal';
    case EllipsisVertical = 'ellipsis-vertical';
    case EnvelopeOpen = 'envelope-open';
    case Envelope = 'envelope';
    case Equals = 'equals';
    case ExclamationCircle = 'exclamation-circle';
    case ExclamationTriangle = 'exclamation-triangle';
    case EyeDropper = 'eye-dropper';
    case EyeSlash = 'eye-slash';
    case Eye = 'eye';
    case FaceFrown = 'face-frown';
    case FaceSmile = 'face-smile';
    case Film = 'film';
    case FingerPrint = 'finger-print';
    case Fire = 'fire';
    case Flag = 'flag';
    case FolderArrowDown = 'folder-arrow-down';
    case FolderMinus = 'folder-minus';
    case FolderOpen = 'folder-open';
    case FolderPlus = 'folder-plus';
    case Folder = 'folder';
    case Forward = 'forward';
    case Funnel = 'funnel';
    case Gif = 'gif';
    case GiftTop = 'gift-top';
    case Gift = 'gift';
    case GlobeAlt = 'globe-alt';
    case GlobeAmericas = 'globe-americas';
    case GlobeAsiaAustralia = 'globe-asia-australia';
    case GlobeEuropeAfrica = 'globe-europe-africa';
    case H1 = 'h1';
    case H2 = 'h2';
    case H3 = 'h3';
    case HandRaised = 'hand-raised';
    case HandThumbDown = 'hand-thumb-down';
    case HandThumbUp = 'hand-thumb-up';
    case Hashtag = 'hashtag';
    case Heart = 'heart';
    case HomeModern = 'home-modern';
    case Home = 'home';
    case Identification = 'identification';
    case InboxArrowDown = 'inbox-arrow-down';
    case InboxStack = 'inbox-stack';
    case Inbox = 'inbox';
    case InformationCircle = 'information-circle';
    case Italic = 'italic';
    case Key = 'key';
    case Language = 'language';
    case Lifebuoy = 'lifebuoy';
    case LightBulb = 'light-bulb';
    case LinkSlash = 'link-slash';
    case Link = 'link';
    case ListBullet = 'list-bullet';
    case LockClosed = 'lock-closed';
    case LockOpen = 'lock-open';
    case MagnifyingGlassCircle = 'magnifying-glass-circle';
    case MagnifyingGlassMinus = 'magnifying-glass-minus';
    case MagnifyingGlassPlus = 'magnifying-glass-plus';
    case MagnifyingGlass = 'magnifying-glass';
    case MapPin = 'map-pin';
    case Map = 'map';
    case Megaphone = 'megaphone';
    case Microphone = 'microphone';
    case MinusCircle = 'minus-circle';
    case MinusSmall = 'minus-small';
    case Minus = 'minus';
    case Moon = 'moon';
    case MusicalNote = 'musical-note';
    case Newspaper = 'newspaper';
    case NoSymbol = 'no-symbol';
    case NumberedList = 'numbered-list';
    case PaintBrush = 'paint-brush';
    case PaperAirplane = 'paper-airplane';
    case PaperClip = 'paper-clip';
    case PauseCircle = 'pause-circle';
    case Pause = 'pause';
    case PencilSquare = 'pencil-square';
    case Pencil = 'pencil';
    case PercentBadge = 'percent-badge';
    case PhoneArrowDownLeft = 'phone-arrow-down-left';
    case PhoneArrowUpRight = 'phone-arrow-up-right';
    case PhoneXMark = 'phone-x-mark';
    case Phone = 'phone';
    case Photo = 'photo';
    case PlayCircle = 'play-circle';
    case PlayPause = 'play-pause';
    case Play = 'play';
    case PlusCircle = 'plus-circle';
    case PlusSmall = 'plus-small';
    case Plus = 'plus';
    case Power = 'power';
    case PresentationChartBar = 'presentation-chart-bar';
    case PresentationChartLine = 'presentation-chart-line';
    case Printer = 'printer';
    case PuzzlePiece = 'puzzle-piece';
    case QrCode = 'qr-code';
    case QuestionMarkCircle = 'question-mark-circle';
    case QueueList = 'queue-list';
    case Radio = 'radio';
    case ReceiptPercent = 'receipt-percent';
    case ReceiptRefund = 'receipt-refund';
    case RectangleGroup = 'rectangle-group';
    case RectangleStack = 'rectangle-stack';
    case RocketLaunch = 'rocket-launch';
    case Rss = 'rss';
    case Scale = 'scale';
    case Scissors = 'scissors';
    case ServerStack = 'server-stack';
    case Server = 'server';
    case Share = 'share';
    case ShieldCheck = 'shield-check';
    case ShieldExclamation = 'shield-exclamation';
    case ShoppingBag = 'shopping-bag';
    case ShoppingCart = 'shopping-cart';
    case SignalSlash = 'signal-slash';
    case Signal = 'signal';
    case Slash = 'slash';
    case Sparkles = 'sparkles';
    case SpeakerWave = 'speaker-wave';
    case SpeakerXMark = 'speaker-x-mark';
    case Square2Stack = 'square-2-stack';
    case Square3Stack3d = 'square-3-stack-3d';
    case Squares2x2 = 'squares-2x2';
    case SquaresPlus = 'squares-plus';
    case Star = 'star';
    case StopCircle = 'stop-circle';
    case Stop = 'stop';
    case Strikethrough = 'strikethrough';
    case Sun = 'sun';
    case Swatch = 'swatch';
    case TableCells = 'table-cells';
    case Tag = 'tag';
    case Ticket = 'ticket';
    case Trash = 'trash';
    case Trophy = 'trophy';
    case Truck = 'truck';
    case Tv = 'tv';
    case Underline = 'underline';
    case UserCircle = 'user-circle';
    case UserGroup = 'user-group';
    case UserMinus = 'user-minus';
    case UserPlus = 'user-plus';
    case User = 'user';
    case Users = 'users';
    case Variable = 'variable';
    case VideoCameraSlash = 'video-camera-slash';
    case VideoCamera = 'video-camera';
    case ViewColumns = 'view-columns';
    case ViewfinderCircle = 'viewfinder-circle';
    case Wallet = 'wallet';
    case Wifi = 'wifi';
    case Window = 'window';
    case WrenchScrewdriver = 'wrench-screwdriver';
    case Wrench = 'wrench';
    case XCircle = 'x-circle';
    case XMark = 'x-mark';
    case OutlinedAcademicCap = 'o-academic-cap';
    case OutlinedAdjustmentsHorizontal = 'o-adjustments-horizontal';
    case OutlinedAdjustmentsVertical = 'o-adjustments-vertical';
    case OutlinedArchiveBoxArrowDown = 'o-archive-box-arrow-down';
    case OutlinedArchiveBoxXMark = 'o-archive-box-x-mark';
    case OutlinedArchiveBox = 'o-archive-box';
    case OutlinedArrowDownCircle = 'o-arrow-down-circle';
    case OutlinedArrowDownLeft = 'o-arrow-down-left';
    case OutlinedArrowDownOnSquareStack = 'o-arrow-down-on-square-stack';
    case OutlinedArrowDownOnSquare = 'o-arrow-down-on-square';
    case OutlinedArrowDownRight = 'o-arrow-down-right';
    case OutlinedArrowDownTray = 'o-arrow-down-tray';
    case OutlinedArrowDown = 'o-arrow-down';
    case OutlinedArrowLeftCircle = 'o-arrow-left-circle';
    case OutlinedArrowLeftEndOnRectangle = 'o-arrow-left-end-on-rectangle';
    case OutlinedArrowLeftOnRectangle = 'o-arrow-left-on-rectangle';
    case OutlinedArrowLeftStartOnRectangle = 'o-arrow-left-start-on-rectangle';
    case OutlinedArrowLeft = 'o-arrow-left';
    case OutlinedArrowLongDown = 'o-arrow-long-down';
    case OutlinedArrowLongLeft = 'o-arrow-long-left';
    case OutlinedArrowLongRight = 'o-arrow-long-right';
    case OutlinedArrowLongUp = 'o-arrow-long-up';
    case OutlinedArrowPathRoundedSquare = 'o-arrow-path-rounded-square';
    case OutlinedArrowPath = 'o-arrow-path';
    case OutlinedArrowRightCircle = 'o-arrow-right-circle';
    case OutlinedArrowRightEndOnRectangle = 'o-arrow-right-end-on-rectangle';
    case OutlinedArrowRightOnRectangle = 'o-arrow-right-on-rectangle';
    case OutlinedArrowRightStartOnRectangle = 'o-arrow-right-start-on-rectangle';
    case OutlinedArrowRight = 'o-arrow-right';
    case OutlinedArrowSmallDown = 'o-arrow-small-down';
    case OutlinedArrowSmallLeft = 'o-arrow-small-left';
    case OutlinedArrowSmallRight = 'o-arrow-small-right';
    case OutlinedArrowSmallUp = 'o-arrow-small-up';
    case OutlinedArrowTopRightOnSquare = 'o-arrow-top-right-on-square';
    case OutlinedArrowTrendingDown = 'o-arrow-trending-down';
    case OutlinedArrowTrendingUp = 'o-arrow-trending-up';
    case OutlinedArrowTurnDownLeft = 'o-arrow-turn-down-left';
    case OutlinedArrowTurnDownRight = 'o-arrow-turn-down-right';
    case OutlinedArrowTurnLeftDown = 'o-arrow-turn-left-down';
    case OutlinedArrowTurnLeftUp = 'o-arrow-turn-left-up';
    case OutlinedArrowTurnRightDown = 'o-arrow-turn-right-down';
    case OutlinedArrowTurnRightUp = 'o-arrow-turn-right-up';
    case OutlinedArrowTurnUpLeft = 'o-arrow-turn-up-left';
    case OutlinedArrowTurnUpRight = 'o-arrow-turn-up-right';
    case OutlinedArrowUpCircle = 'o-arrow-up-circle';
    case OutlinedArrowUpLeft = 'o-arrow-up-left';
    case OutlinedArrowUpOnSquareStack = 'o-arrow-up-on-square-stack';
    case OutlinedArrowUpOnSquare = 'o-arrow-up-on-square';
    case OutlinedArrowUpRight = 'o-arrow-up-right';
    case OutlinedArrowUpTray = 'o-arrow-up-tray';
    case OutlinedArrowUp = 'o-arrow-up';
    case OutlinedArrowUturnDown = 'o-arrow-uturn-down';
    case OutlinedArrowUturnLeft = 'o-arrow-uturn-left';
    case OutlinedArrowUturnRight = 'o-arrow-uturn-right';
    case OutlinedArrowUturnUp = 'o-arrow-uturn-up';
    case OutlinedArrowsPointingIn = 'o-arrows-pointing-in';
    case OutlinedArrowsPointingOut = 'o-arrows-pointing-out';
    case OutlinedArrowsRightLeft = 'o-arrows-right-left';
    case OutlinedArrowsUpDown = 'o-arrows-up-down';
    case OutlinedAtSymbol = 'o-at-symbol';
    case OutlinedBackspace = 'o-backspace';
    case OutlinedBackward = 'o-backward';
    case OutlinedBanknotes = 'o-banknotes';
    case OutlinedBars2 = 'o-bars-2';
    case OutlinedBars3BottomLeft = 'o-bars-3-bottom-left';
    case OutlinedBars3BottomRight = 'o-bars-3-bottom-right';
    case OutlinedBars3CenterLeft = 'o-bars-3-center-left';
    case OutlinedBars3 = 'o-bars-3';
    case OutlinedBars4 = 'o-bars-4';
    case OutlinedBarsArrowDown = 'o-bars-arrow-down';
    case OutlinedBarsArrowUp = 'o-bars-arrow-up';
    case OutlinedBattery0 = 'o-battery-0';
    case OutlinedBattery100 = 'o-battery-100';
    case OutlinedBattery50 = 'o-battery-50';
    case OutlinedBeaker = 'o-beaker';
    case OutlinedBellAlert = 'o-bell-alert';
    case OutlinedBellSlash = 'o-bell-slash';
    case OutlinedBellSnooze = 'o-bell-snooze';
    case OutlinedBell = 'o-bell';
    case OutlinedBold = 'o-bold';
    case OutlinedBoltSlash = 'o-bolt-slash';
    case OutlinedBolt = 'o-bolt';
    case OutlinedBookOpen = 'o-book-open';
    case OutlinedBookmarkSlash = 'o-bookmark-slash';
    case OutlinedBookmarkSquare = 'o-bookmark-square';
    case OutlinedBookmark = 'o-bookmark';
    case OutlinedBriefcase = 'o-briefcase';
    case OutlinedBugAnt = 'o-bug-ant';
    case OutlinedBuildingLibrary = 'o-building-library';
    case OutlinedBuildingOffice2 = 'o-building-office-2';
    case OutlinedBuildingOffice = 'o-building-office';
    case OutlinedBuildingStorefront = 'o-building-storefront';
    case OutlinedCake = 'o-cake';
    case OutlinedCalculator = 'o-calculator';
    case OutlinedCalendarDateRange = 'o-calendar-date-range';
    case OutlinedCalendarDays = 'o-calendar-days';
    case OutlinedCalendar = 'o-calendar';
    case OutlinedCamera = 'o-camera';
    case OutlinedChartBarSquare = 'o-chart-bar-square';
    case OutlinedChartBar = 'o-chart-bar';
    case OutlinedChartPie = 'o-chart-pie';
    case OutlinedChatBubbleBottomCenterText = 'o-chat-bubble-bottom-center-text';
    case OutlinedChatBubbleBottomCenter = 'o-chat-bubble-bottom-center';
    case OutlinedChatBubbleLeftEllipsis = 'o-chat-bubble-left-ellipsis';
    case OutlinedChatBubbleLeftRight = 'o-chat-bubble-left-right';
    case OutlinedChatBubbleLeft = 'o-chat-bubble-left';
    case OutlinedChatBubbleOvalLeftEllipsis = 'o-chat-bubble-oval-left-ellipsis';
    case OutlinedChatBubbleOvalLeft = 'o-chat-bubble-oval-left';
    case OutlinedCheckBadge = 'o-check-badge';
    case OutlinedCheckCircle = 'o-check-circle';
    case OutlinedCheck = 'o-check';
    case OutlinedChevronDoubleDown = 'o-chevron-double-down';
    case OutlinedChevronDoubleLeft = 'o-chevron-double-left';
    case OutlinedChevronDoubleRight = 'o-chevron-double-right';
    case OutlinedChevronDoubleUp = 'o-chevron-double-up';
    case OutlinedChevronDown = 'o-chevron-down';
    case OutlinedChevronLeft = 'o-chevron-left';
    case OutlinedChevronRight = 'o-chevron-right';
    case OutlinedChevronUpDown = 'o-chevron-up-down';
    case OutlinedChevronUp = 'o-chevron-up';
    case OutlinedCircleStack = 'o-circle-stack';
    case OutlinedClipboardDocumentCheck = 'o-clipboard-document-check';
    case OutlinedClipboardDocumentList = 'o-clipboard-document-list';
    case OutlinedClipboardDocument = 'o-clipboard-document';
    case OutlinedClipboard = 'o-clipboard';
    case OutlinedClock = 'o-clock';
    case OutlinedCloudArrowDown = 'o-cloud-arrow-down';
    case OutlinedCloudArrowUp = 'o-cloud-arrow-up';
    case OutlinedCloud = 'o-cloud';
    case OutlinedCodeBracketSquare = 'o-code-bracket-square';
    case OutlinedCodeBracket = 'o-code-bracket';
    case OutlinedCog6Tooth = 'o-cog-6-tooth';
    case OutlinedCog8Tooth = 'o-cog-8-tooth';
    case OutlinedCog = 'o-cog';
    case OutlinedCommandLine = 'o-command-line';
    case OutlinedComputerDesktop = 'o-computer-desktop';
    case OutlinedCpuChip = 'o-cpu-chip';
    case OutlinedCreditCard = 'o-credit-card';
    case OutlinedCubeTransparent = 'o-cube-transparent';
    case OutlinedCube = 'o-cube';
    case OutlinedCurrencyBangladeshi = 'o-currency-bangladeshi';
    case OutlinedCurrencyDollar = 'o-currency-dollar';
    case OutlinedCurrencyEuro = 'o-currency-euro';
    case OutlinedCurrencyPound = 'o-currency-pound';
    case OutlinedCurrencyRupee = 'o-currency-rupee';
    case OutlinedCurrencyYen = 'o-currency-yen';
    case OutlinedCursorArrowRays = 'o-cursor-arrow-rays';
    case OutlinedCursorArrowRipple = 'o-cursor-arrow-ripple';
    case OutlinedDevicePhoneMobile = 'o-device-phone-mobile';
    case OutlinedDeviceTablet = 'o-device-tablet';
    case OutlinedDivide = 'o-divide';
    case OutlinedDocumentArrowDown = 'o-document-arrow-down';
    case OutlinedDocumentArrowUp = 'o-document-arrow-up';
    case OutlinedDocumentChartBar = 'o-document-chart-bar';
    case OutlinedDocumentCheck = 'o-document-check';
    case OutlinedDocumentCurrencyBangladeshi = 'o-document-currency-bangladeshi';
    case OutlinedDocumentCurrencyDollar = 'o-document-currency-dollar';
    case OutlinedDocumentCurrencyEuro = 'o-document-currency-euro';
    case OutlinedDocumentCurrencyPound = 'o-document-currency-pound';
    case OutlinedDocumentCurrencyRupee = 'o-document-currency-rupee';
    case OutlinedDocumentCurrencyYen = 'o-document-currency-yen';
    case OutlinedDocumentDuplicate = 'o-document-duplicate';
    case OutlinedDocumentMagnifyingGlass = 'o-document-magnifying-glass';
    case OutlinedDocumentMinus = 'o-document-minus';
    case OutlinedDocumentPlus = 'o-document-plus';
    case OutlinedDocumentText = 'o-document-text';
    case OutlinedDocument = 'o-document';
    case OutlinedEllipsisHorizontalCircle = 'o-ellipsis-horizontal-circle';
    case OutlinedEllipsisHorizontal = 'o-ellipsis-horizontal';
    case OutlinedEllipsisVertical = 'o-ellipsis-vertical';
    case OutlinedEnvelopeOpen = 'o-envelope-open';
    case OutlinedEnvelope = 'o-envelope';
    case OutlinedEquals = 'o-equals';
    case OutlinedExclamationCircle = 'o-exclamation-circle';
    case OutlinedExclamationTriangle = 'o-exclamation-triangle';
    case OutlinedEyeDropper = 'o-eye-dropper';
    case OutlinedEyeSlash = 'o-eye-slash';
    case OutlinedEye = 'o-eye';
    case OutlinedFaceFrown = 'o-face-frown';
    case OutlinedFaceSmile = 'o-face-smile';
    case OutlinedFilm = 'o-film';
    case OutlinedFingerPrint = 'o-finger-print';
    case OutlinedFire = 'o-fire';
    case OutlinedFlag = 'o-flag';
    case OutlinedFolderArrowDown = 'o-folder-arrow-down';
    case OutlinedFolderMinus = 'o-folder-minus';
    case OutlinedFolderOpen = 'o-folder-open';
    case OutlinedFolderPlus = 'o-folder-plus';
    case OutlinedFolder = 'o-folder';
    case OutlinedForward = 'o-forward';
    case OutlinedFunnel = 'o-funnel';
    case OutlinedGif = 'o-gif';
    case OutlinedGiftTop = 'o-gift-top';
    case OutlinedGift = 'o-gift';
    case OutlinedGlobeAlt = 'o-globe-alt';
    case OutlinedGlobeAmericas = 'o-globe-americas';
    case OutlinedGlobeAsiaAustralia = 'o-globe-asia-australia';
    case OutlinedGlobeEuropeAfrica = 'o-globe-europe-africa';
    case OutlinedH1 = 'o-h1';
    case OutlinedH2 = 'o-h2';
    case OutlinedH3 = 'o-h3';
    case OutlinedHandRaised = 'o-hand-raised';
    case OutlinedHandThumbDown = 'o-hand-thumb-down';
    case OutlinedHandThumbUp = 'o-hand-thumb-up';
    case OutlinedHashtag = 'o-hashtag';
    case OutlinedHeart = 'o-heart';
    case OutlinedHomeModern = 'o-home-modern';
    case OutlinedHome = 'o-home';
    case OutlinedIdentification = 'o-identification';
    case OutlinedInboxArrowDown = 'o-inbox-arrow-down';
    case OutlinedInboxStack = 'o-inbox-stack';
    case OutlinedInbox = 'o-inbox';
    case OutlinedInformationCircle = 'o-information-circle';
    case OutlinedItalic = 'o-italic';
    case OutlinedKey = 'o-key';
    case OutlinedLanguage = 'o-language';
    case OutlinedLifebuoy = 'o-lifebuoy';
    case OutlinedLightBulb = 'o-light-bulb';
    case OutlinedLinkSlash = 'o-link-slash';
    case OutlinedLink = 'o-link';
    case OutlinedListBullet = 'o-list-bullet';
    case OutlinedLockClosed = 'o-lock-closed';
    case OutlinedLockOpen = 'o-lock-open';
    case OutlinedMagnifyingGlassCircle = 'o-magnifying-glass-circle';
    case OutlinedMagnifyingGlassMinus = 'o-magnifying-glass-minus';
    case OutlinedMagnifyingGlassPlus = 'o-magnifying-glass-plus';
    case OutlinedMagnifyingGlass = 'o-magnifying-glass';
    case OutlinedMapPin = 'o-map-pin';
    case OutlinedMap = 'o-map';
    case OutlinedMegaphone = 'o-megaphone';
    case OutlinedMicrophone = 'o-microphone';
    case OutlinedMinusCircle = 'o-minus-circle';
    case OutlinedMinusSmall = 'o-minus-small';
    case OutlinedMinus = 'o-minus';
    case OutlinedMoon = 'o-moon';
    case OutlinedMusicalNote = 'o-musical-note';
    case OutlinedNewspaper = 'o-newspaper';
    case OutlinedNoSymbol = 'o-no-symbol';
    case OutlinedNumberedList = 'o-numbered-list';
    case OutlinedPaintBrush = 'o-paint-brush';
    case OutlinedPaperAirplane = 'o-paper-airplane';
    case OutlinedPaperClip = 'o-paper-clip';
    case OutlinedPauseCircle = 'o-pause-circle';
    case OutlinedPause = 'o-pause';
    case OutlinedPencilSquare = 'o-pencil-square';
    case OutlinedPencil = 'o-pencil';
    case OutlinedPercentBadge = 'o-percent-badge';
    case OutlinedPhoneArrowDownLeft = 'o-phone-arrow-down-left';
    case OutlinedPhoneArrowUpRight = 'o-phone-arrow-up-right';
    case OutlinedPhoneXMark = 'o-phone-x-mark';
    case OutlinedPhone = 'o-phone';
    case OutlinedPhoto = 'o-photo';
    case OutlinedPlayCircle = 'o-play-circle';
    case OutlinedPlayPause = 'o-play-pause';
    case OutlinedPlay = 'o-play';
    case OutlinedPlusCircle = 'o-plus-circle';
    case OutlinedPlusSmall = 'o-plus-small';
    case OutlinedPlus = 'o-plus';
    case OutlinedPower = 'o-power';
    case OutlinedPresentationChartBar = 'o-presentation-chart-bar';
    case OutlinedPresentationChartLine = 'o-presentation-chart-line';
    case OutlinedPrinter = 'o-printer';
    case OutlinedPuzzlePiece = 'o-puzzle-piece';
    case OutlinedQrCode = 'o-qr-code';
    case OutlinedQuestionMarkCircle = 'o-question-mark-circle';
    case OutlinedQueueList = 'o-queue-list';
    case OutlinedRadio = 'o-radio';
    case OutlinedReceiptPercent = 'o-receipt-percent';
    case OutlinedReceiptRefund = 'o-receipt-refund';
    case OutlinedRectangleGroup = 'o-rectangle-group';
    case OutlinedRectangleStack = 'o-rectangle-stack';
    case OutlinedRocketLaunch = 'o-rocket-launch';
    case OutlinedRss = 'o-rss';
    case OutlinedScale = 'o-scale';
    case OutlinedScissors = 'o-scissors';
    case OutlinedServerStack = 'o-server-stack';
    case OutlinedServer = 'o-server';
    case OutlinedShare = 'o-share';
    case OutlinedShieldCheck = 'o-shield-check';
    case OutlinedShieldExclamation = 'o-shield-exclamation';
    case OutlinedShoppingBag = 'o-shopping-bag';
    case OutlinedShoppingCart = 'o-shopping-cart';
    case OutlinedSignalSlash = 'o-signal-slash';
    case OutlinedSignal = 'o-signal';
    case OutlinedSlash = 'o-slash';
    case OutlinedSparkles = 'o-sparkles';
    case OutlinedSpeakerWave = 'o-speaker-wave';
    case OutlinedSpeakerXMark = 'o-speaker-x-mark';
    case OutlinedSquare2Stack = 'o-square-2-stack';
    case OutlinedSquare3Stack3d = 'o-square-3-stack-3d';
    case OutlinedSquares2x2 = 'o-squares-2x2';
    case OutlinedSquaresPlus = 'o-squares-plus';
    case OutlinedStar = 'o-star';
    case OutlinedStopCircle = 'o-stop-circle';
    case OutlinedStop = 'o-stop';
    case OutlinedStrikethrough = 'o-strikethrough';
    case OutlinedSun = 'o-sun';
    case OutlinedSwatch = 'o-swatch';
    case OutlinedTableCells = 'o-table-cells';
    case OutlinedTag = 'o-tag';
    case OutlinedTicket = 'o-ticket';
    case OutlinedTrash = 'o-trash';
    case OutlinedTrophy = 'o-trophy';
    case OutlinedTruck = 'o-truck';
    case OutlinedTv = 'o-tv';
    case OutlinedUnderline = 'o-underline';
    case OutlinedUserCircle = 'o-user-circle';
    case OutlinedUserGroup = 'o-user-group';
    case OutlinedUserMinus = 'o-user-minus';
    case OutlinedUserPlus = 'o-user-plus';
    case OutlinedUser = 'o-user';
    case OutlinedUsers = 'o-users';
    case OutlinedVariable = 'o-variable';
    case OutlinedVideoCameraSlash = 'o-video-camera-slash';
    case OutlinedVideoCamera = 'o-video-camera';
    case OutlinedViewColumns = 'o-view-columns';
    case OutlinedViewfinderCircle = 'o-viewfinder-circle';
    case OutlinedWallet = 'o-wallet';
    case OutlinedWifi = 'o-wifi';
    case OutlinedWindow = 'o-window';
    case OutlinedWrenchScrewdriver = 'o-wrench-screwdriver';
    case OutlinedWrench = 'o-wrench';
    case OutlinedXCircle = 'o-x-circle';
    case OutlinedXMark = 'o-x-mark';

    public function getIconForSize(IconSize $size): string
    {
        if (str_starts_with($this->value, 'o-')) {
            return "heroicon-{$this->value}";
        }

        return match ($size) {
            IconSize::ExtraSmall, IconSize::Small => "heroicon-c-{$this->value}",
            IconSize::Medium => "heroicon-m-{$this->value}",
            IconSize::Large, IconSize::ExtraLarge, IconSize::TwoExtraLarge => "heroicon-s-{$this->value}",
        };
    }
}
