<?php

namespace Tests\Feature;

use App\Models\Booking;
use App\Models\Service;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class RescheduleProposalTest extends TestCase
{
    use RefreshDatabase;

    public function test_provider_can_propose_and_customer_accepts(): void
    {
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'provider']);
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'customer']);

        $provider = User::factory()->create();
        $provider->assignRole('provider');
        $customer = User::factory()->create();
        $customer->assignRole('customer');
        $service = Service::factory()->create(['user_id' => $provider->id]);

        $booking = Booking::create([
            'service_id' => $service->id,
            'customer_id' => $customer->id,
            'provider_id' => $provider->id,
            'status' => 'confirmed',
            'booking_mode' => 'instant',
            'scheduling_type' => 'fixed_datetime',
            'delivery_mode' => 'online',
            'amount' => 100,
            'currency' => 'USD',
        ]);

        $newTime = now()->addDay()->format('Y-m-d\TH:i');
        $this->actingAs($provider)->post(route('bookings.proposal', $booking), ['slot_start' => $newTime]);

        $this->assertEquals('pending_provider_approval', $booking->refresh()->status);

        $this->actingAs($customer)->post(route('bookings.proposal.accept', $booking));

        $this->assertEquals('confirmed', $booking->refresh()->status);
        $this->assertNull(data_get($booking->meta, 'proposed_start'));
    }
}
