<?php

namespace Tests\Feature;

use App\Models\Booking;
use App\Models\PaymentGateway;
use App\Models\Service;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class PaymentInitiationTest extends TestCase
{
    use RefreshDatabase;

    public function test_customer_can_initiate_payment()
    {
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'provider']);
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'customer']);

        $gateway = PaymentGateway::create([
            'name' => 'stripe',
            'display_name' => 'Stripe',
            'mode' => 'test',
            'enabled' => true,
        ]);

        $provider = User::factory()->create();
        $provider->assignRole('provider');
        $customer = User::factory()->create();
        $customer->assignRole('customer');

        $service = Service::factory()->create(['user_id' => $provider->id, 'booking_mode' => 'instant']);

        $booking = Booking::create([
            'service_id' => $service->id,
            'customer_id' => $customer->id,
            'provider_id' => $provider->id,
            'status' => 'draft',
            'booking_mode' => 'instant',
            'scheduling_type' => 'fixed_datetime',
            'delivery_mode' => 'online',
            'amount' => 100,
            'currency' => 'USD',
        ]);

        $response = $this->actingAs($customer)->post(route('bookings.pay.process', $booking), [
            'gateway_id' => $gateway->id,
        ]);

        $response->assertStatus(200)->assertViewIs('payments.confirm');
        $this->assertDatabaseHas('payments', ['booking_id' => $booking->id]);
    }
}
