<?php

namespace Tests\Feature;

use App\Models\Booking;
use App\Models\Service;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class DisputeFlowTest extends TestCase
{
    use RefreshDatabase;

    public function test_customer_can_open_dispute(): void
    {
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'provider']);
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'customer']);

        $provider = User::factory()->create();
        $provider->assignRole('provider');
        $customer = User::factory()->create();
        $customer->assignRole('customer');
        $service = Service::factory()->create(['user_id' => $provider->id]);

        $booking = Booking::create([
            'service_id' => $service->id,
            'customer_id' => $customer->id,
            'provider_id' => $provider->id,
            'status' => 'confirmed',
            'booking_mode' => 'instant',
            'scheduling_type' => 'fixed_datetime',
            'delivery_mode' => 'online',
            'amount' => 100,
            'currency' => 'USD',
        ]);

        $response = $this->actingAs($customer)->post(route('bookings.disputes.store', $booking), [
            'reason' => 'Issue with service',
        ]);

        $response->assertRedirect();
        $this->assertDatabaseHas('disputes', ['booking_id' => $booking->id, 'reason' => 'Issue with service']);
        $this->assertEquals('disputed', $booking->refresh()->status);
    }
}
