<?php

namespace Tests\Feature;

use App\Models\Booking;
use App\Models\Dispute;
use App\Models\DisputeEvent;
use App\Models\Service;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class DisputeEventTest extends TestCase
{
    use RefreshDatabase;

    public function test_dispute_events_recorded(): void
    {
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'provider']);
        \Spatie\Permission\Models\Role::firstOrCreate(['name' => 'customer']);

        $provider = User::factory()->create();
        $provider->assignRole('provider');
        $customer = User::factory()->create();
        $customer->assignRole('customer');
        $service = Service::factory()->create(['user_id' => $provider->id]);

        $booking = Booking::create([
            'service_id' => $service->id,
            'customer_id' => $customer->id,
            'provider_id' => $provider->id,
            'status' => 'confirmed',
            'booking_mode' => 'instant',
            'scheduling_type' => 'fixed_datetime',
            'delivery_mode' => 'online',
            'amount' => 100,
            'currency' => 'USD',
        ]);

        $dispute = Dispute::create([
            'booking_id' => $booking->id,
            'opened_by' => $customer->id,
            'status' => 'open',
            'reason' => 'Issue',
            'opened_at' => now(),
        ]);

        DisputeEvent::create([
            'dispute_id' => $dispute->id,
            'user_id' => $customer->id,
            'action' => 'opened',
            'notes' => 'Customer opened dispute',
        ]);

        $this->assertDatabaseHas('dispute_events', ['dispute_id' => $dispute->id, 'action' => 'opened']);
    }
}
