<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ $service->title }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8 grid md:grid-cols-3 gap-6">
            <div class="md:col-span-2 space-y-4">
                <div class="bg-white p-6 rounded-lg shadow">
                    <p class="text-sm text-gray-500">{{ $service->category?->name }}</p>
                    <p class="text-gray-800">{{ $service->description }}</p>
                    <p class="mt-2 text-sm text-gray-600">Delivery: {{ $service->delivery_mode }} · Booking: {{ $service->booking_mode }}</p>
                    <p class="mt-2 text-lg font-semibold">${{ number_format($service->base_price, 2) }} {{ $service->currency }}</p>
                </div>

                <div class="bg-white p-6 rounded-lg shadow">
                    <h3 class="font-semibold mb-3">Pick a time</h3>
                    <div x-data="availabilityPicker()" x-init="loadSlots()">
                        <input type="date" x-model="selectedDate" @change="filterByDate" class="border rounded px-3 py-2 mb-3">
                        <div class="grid md:grid-cols-3 gap-2">
                            <template x-for="slot in filteredSlots" :key="slot.start">
                                <label class="border rounded px-3 py-2 flex items-center gap-2 cursor-pointer">
                                    <input type="radio" name="slot_start" :value="slot.start" x-model="selectedSlot">
                                    <span x-text="formatSlot(slot)"></span>
                                </label>
                            </template>
                        </div>
                        <form method="POST" action="{{ route('services.book', $service) }}" class="mt-4">
                            @csrf
                            <input type="hidden" name="slot_start" :value="selectedSlot">
                            <textarea name="notes" placeholder="Notes" class="w-full border rounded px-3 py-2 mb-3"></textarea>
                            <button class="px-4 py-2 bg-indigo-600 text-white rounded" :disabled="!selectedSlot">Book</button>
                        </form>
                    </div>
                </div>
            </div>

            <div class="space-y-4">
                <div class="bg-white p-6 rounded-lg shadow">
                    <p class="text-sm text-gray-500">Provider</p>
                    <p class="font-semibold">{{ $service->provider?->name }}</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow">
                    <p class="font-semibold mb-2">Details</p>
                    <p class="text-sm text-gray-600">Duration: {{ $service->duration_minutes }} mins</p>
                    <p class="text-sm text-gray-600">Capacity: {{ $service->capacity }}</p>
                </div>
            </div>
        </div>
    </div>

<script>
        function availabilityPicker() {
            return {
                slots: [],
                filteredSlots: [],
                selectedDate: new Date().toISOString().slice(0,10),
                selectedSlot: '',
                async loadSlots() {
                    const res = await fetch('{{ route('availability.slots', $service) }}');
                    const data = await res.json();
                    this.slots = data.slots.map(s => ({...s, start: s.start, end: s.end}));
                    this.filterByDate();
                },
                filterByDate() {
                    this.filteredSlots = this.slots.filter(s => s.start.startsWith(this.selectedDate));
                    this.selectedSlot = this.filteredSlots[0]?.start || '';
                },
                formatSlot(slot) {
                    return new Date(slot.start).toLocaleTimeString([], {hour: '2-digit', minute: '2-digit'}) + ' - ' + new Date(slot.end).toLocaleTimeString([], {hour: '2-digit', minute: '2-digit'});
                }
            }
        }
    </script>
</x-app-layout>
