<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Pay for Booking #'.$booking->id) }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white p-6 rounded-lg shadow space-y-4">
                <div>
                    <p class="text-sm text-gray-500">Service</p>
                    <p class="font-semibold">{{ $booking->service?->title }}</p>
                    <p class="text-sm text-gray-600">Amount: ${{ number_format($booking->amount, 2) }} {{ $booking->currency }}</p>
                </div>

                <form action="{{ route('bookings.pay.process', $booking) }}" method="POST" class="space-y-3">
                    @csrf
                    <label class="block text-sm text-gray-600">Select payment method</label>
                    <div class="space-y-2">
                        @foreach($gateways as $gateway)
                            <label class="flex items-center gap-2 border rounded px-3 py-2 cursor-pointer">
                                <input type="radio" name="gateway_id" value="{{ $gateway->id }}" class="w-4 h-4">
                                <div>
                                    <p class="font-semibold">{{ $gateway->display_name }}</p>
                                    <p class="text-xs text-gray-500">{{ $gateway->mode === 'live' ? 'Live' : 'Test' }}</p>
                                </div>
                            </label>
                        @endforeach
                    </div>
                    <button class="px-4 py-2 bg-indigo-600 text-white rounded">Pay & Continue</button>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
