<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Complete Payment') }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white p-6 rounded-lg shadow space-y-3">
                <p class="text-sm text-gray-600">Booking #{{ $booking->id }} · {{ $payment->gateway->display_name }}</p>
                <p class="text-lg font-semibold">${{ number_format($payment->amount, 2) }} {{ $payment->currency }}</p>
                @if(isset($payment->payload['client_secret']))
                    <p class="text-sm text-gray-600">Use this client secret with Stripe Elements/SDK:</p>
                    <code class="text-xs bg-gray-100 px-2 py-1 rounded">{{ $payment->payload['client_secret'] }}</code>
                @elseif(isset($payment->payload['approval_url']))
                    <a href="{{ $payment->payload['approval_url'] }}" class="px-4 py-2 bg-indigo-600 text-white rounded inline-block">Continue to PayPal</a>
                @elseif(isset($payment->payload['authorization_url']))
                    <a href="{{ $payment->payload['authorization_url'] }}" class="px-4 py-2 bg-indigo-600 text-white rounded inline-block">Continue to Paystack</a>
                @endif
                <a href="{{ route('customer.dashboard') }}" class="text-indigo-600 text-sm block mt-2">Back to dashboard</a>
            </div>
        </div>
    </div>
</x-app-layout>
