@php
    use Illuminate\Support\Str;
    $type = $section['type'] ?? 'content';
    $items = $section['items'] ?? [];
@endphp

@switch($type)
    @case('hero')
        <section class="relative overflow-hidden rounded-2xl bg-gradient-to-r from-emerald-500 via-emerald-600 to-emerald-700 text-white shadow">
            <div class="absolute inset-0 opacity-20 bg-[radial-gradient(circle_at_top_left,_#ffffff,_transparent_35%)]"></div>
            <div class="relative p-10 flex flex-col gap-4 md:flex-row md:items-center md:justify-between">
                <div class="space-y-3">
                    <p class="text-sm font-semibold uppercase tracking-wide text-emerald-100">{{ $section['subtitle'] ?? 'Trusted marketplace' }}</p>
                    <h1 class="text-3xl md:text-4xl font-bold leading-tight">{{ $section['title'] ?? '' }}</h1>
                    @if(!empty($section['body']))
                        <p class="text-lg text-emerald-50 max-w-2xl">{{ $section['body'] }}</p>
                    @endif
                    @if(!empty($section['cta_label']))
                        <div class="flex gap-3">
                            <a href="{{ $section['cta_url'] ?? '#' }}" class="inline-flex items-center px-4 py-2 bg-white text-emerald-700 font-semibold rounded-lg shadow hover:-translate-y-0.5 transition">
                                {{ $section['cta_label'] }}
                            </a>
                        </div>
                    @endif
                </div>
                <div class="mt-6 md:mt-0">
                    <div class="bg-white/10 border border-white/20 rounded-xl p-4 backdrop-blur">
                        <div class="text-sm text-emerald-100">Escrow & payouts</div>
                        <div class="text-3xl font-bold">{{ config('app.name') }}</div>
                        <p class="mt-2 text-emerald-50 max-w-sm">Funds stay protected until completion and approvals, with dispute and refund rails built in.</p>
                    </div>
                </div>
            </div>
        </section>
        @break

    @case('features')
        <section class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center justify-between gap-3 flex-wrap">
                <div>
                    <p class="text-emerald-600 text-sm font-semibold">{{ $section['subtitle'] ?? 'Features' }}</p>
                    <h2 class="text-2xl font-bold text-gray-900">{{ $section['title'] ?? '' }}</h2>
                </div>
            </div>
            <div class="mt-4 grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                @foreach($items as $item)
                    <div class="rounded-lg border border-gray-100 p-4 shadow-sm">
                        <div class="flex items-start gap-3">
                            <span class="mt-1 inline-flex h-8 w-8 items-center justify-center rounded-full bg-emerald-50 text-emerald-600">✓</span>
                            <div>
                                <div class="font-semibold text-gray-900">{{ $item['title'] ?? '' }}</div>
                                <p class="text-sm text-gray-600 mt-1">{{ $item['description'] ?? '' }}</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </section>
        @break

    @case('faq')
        <section class="bg-white rounded-xl shadow-sm p-6">
            <div class="mb-4">
                <p class="text-emerald-600 text-sm font-semibold">{{ $section['subtitle'] ?? 'Support' }}</p>
                <h2 class="text-2xl font-bold text-gray-900">{{ $section['title'] ?? 'FAQs' }}</h2>
            </div>
            <div class="space-y-3">
                @foreach($items as $item)
                    <details class="group rounded-lg border border-gray-100 p-4">
                        <summary class="flex cursor-pointer items-center justify-between gap-4 text-gray-900 font-semibold">
                            {{ $item['title'] ?? '' }}
                            <span class="text-emerald-600 group-open:rotate-45 transition">+</span>
                        </summary>
                        <div class="mt-2 text-gray-600 leading-relaxed">{{ $item['description'] ?? '' }}</div>
                    </details>
                @endforeach
            </div>
        </section>
        @break

    @case('stats')
        <section class="bg-white rounded-xl shadow-sm p-6">
            <div class="mb-4">
                <p class="text-emerald-600 text-sm font-semibold">{{ $section['subtitle'] ?? 'Operational defaults' }}</p>
                <h2 class="text-2xl font-bold text-gray-900">{{ $section['title'] ?? 'Stats' }}</h2>
            </div>
            <div class="grid gap-4 sm:grid-cols-3">
                @foreach($items as $item)
                    <div class="rounded-lg border border-gray-100 p-4">
                        <div class="text-3xl font-bold text-gray-900">{{ $item['title'] ?? '' }}</div>
                        <div class="text-sm text-gray-600 mt-1">{{ $item['description'] ?? '' }}</div>
                    </div>
                @endforeach
            </div>
        </section>
        @break

    @case('cta')
        <section class="rounded-xl bg-gray-900 text-white p-8 shadow">
            <div class="flex flex-col gap-3 md:flex-row md:items-center md:justify-between">
                <div>
                    <h3 class="text-2xl font-bold">{{ $section['title'] ?? '' }}</h3>
                    <p class="text-gray-200 mt-2 max-w-2xl">{{ $section['body'] ?? '' }}</p>
                </div>
                @if(!empty($section['cta_label']))
                    <a href="{{ $section['cta_url'] ?? '#' }}" class="inline-flex items-center px-4 py-2 bg-white text-gray-900 font-semibold rounded-lg shadow hover:-translate-y-0.5 transition">
                        {{ $section['cta_label'] }}
                    </a>
                @endif
            </div>
        </section>
        @break

    @default
        <section class="bg-white rounded-xl shadow-sm p-6 prose max-w-none">
            @if(!empty($section['title']))
                <h2 class="text-2xl font-bold">{{ $section['title'] }}</h2>
            @endif
            @if(!empty($section['body']))
                {!! Str::markdown($section['body']) !!}
            @else
                {!! $section['content'] ?? '' !!}
            @endif
        </section>
@endswitch
