<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Messages for Booking #'.$booking->id) }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8 space-y-4">
            <div class="bg-white rounded-lg shadow p-4 space-y-3">
                @forelse($messages as $message)
                    <div class="{{ $message->sender_id === auth()->id() ? 'text-right' : 'text-left' }}">
                        <div class="inline-block px-3 py-2 rounded {{ $message->sender_id === auth()->id() ? 'bg-indigo-100' : 'bg-gray-100' }}">
                            <p class="text-sm text-gray-700">{{ $message->body }}</p>
                            <p class="text-xs text-gray-500">{{ $message->created_at->diffForHumans() }}</p>
                        </div>
                    </div>
                @empty
                    <p class="text-gray-500 text-sm">No messages yet.</p>
                @endforelse
            </div>

            <form action="{{ route((auth()->user()->hasRole('provider') ? 'provider.bookings.messages.store' : 'bookings.messages.store'), $booking) }}" method="POST" class="bg-white rounded-lg shadow p-4 space-y-3">
                @csrf
                <textarea name="body" class="w-full border rounded px-3 py-2" placeholder="Type message..." required></textarea>
                <button class="px-4 py-2 bg-indigo-600 text-white rounded">Send</button>
            </form>
        </div>
    </div>
</x-app-layout>
