<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installer</title>
    @vite('resources/css/app.css')
</head>
<body class="bg-slate-950 text-white min-h-screen">
<div class="max-w-5xl mx-auto py-10 space-y-8">
    <header class="flex items-center justify-between">
        <div>
            <p class="text-sm text-slate-400 uppercase tracking-widest">Setup</p>
            <h1 class="text-3xl font-semibold">Service Marketplace Installer</h1>
        </div>
        <span class="px-3 py-1 rounded-full bg-emerald-500/10 text-emerald-300 text-sm">Step through to finish</span>
    </header>

    <section class="bg-slate-900/70 border border-slate-800 rounded-xl p-6">
        <h2 class="text-xl font-semibold mb-3">1. Requirements</h2>
        <div class="grid md:grid-cols-2 gap-3">
            <div class="p-4 rounded-lg bg-slate-800/50">
                <p class="text-sm text-slate-400">PHP 8.2+</p>
                <p class="text-lg font-semibold {{ $requirements['php'] ? 'text-emerald-400' : 'text-rose-400' }}">
                    {{ $requirements['php'] ? 'OK' : 'Upgrade PHP' }}
                </p>
            </div>
            <div class="p-4 rounded-lg bg-slate-800/50">
                <p class="text-sm text-slate-400">Extensions</p>
                <ul class="text-sm space-y-1">
                    @foreach($requirements['extensions'] as $ext => $ok)
                        <li class="{{ $ok ? 'text-emerald-300' : 'text-rose-300' }}">{{ $ext }}: {{ $ok ? 'yes' : 'missing' }}</li>
                    @endforeach
                </ul>
            </div>
            <div class="p-4 rounded-lg bg-slate-800/50">
                <p class="text-sm text-slate-400">Storage writable</p>
                <p class="{{ $requirements['storage_writable'] ? 'text-emerald-300' : 'text-rose-300' }}">{{ $requirements['storage_writable'] ? 'yes' : 'no' }}</p>
            </div>
            <div class="p-4 rounded-lg bg-slate-800/50">
                <p class="text-sm text-slate-400">Cache/Queue configured</p>
                <p class="text-emerald-300">cache: {{ $requirements['cache'] ? 'ok' : 'missing' }}, queue: {{ $requirements['queue'] ? 'ok' : 'missing' }}</p>
            </div>
        </div>
    </section>

    <section class="bg-slate-900/70 border border-slate-800 rounded-xl p-6 space-y-4">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold">2. Database setup</h2>
            @if(session('db_saved'))
                <span class="text-emerald-400 text-sm">Saved</span>
            @endif
        </div>
        <form action="{{ route('install.database.save') }}" method="post" class="grid md:grid-cols-2 gap-4" id="db-form">
            @csrf
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Driver</label>
                <input name="driver" value="mysql" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Host</label>
                <input name="host" value="127.0.0.1" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Port</label>
                <input name="port" value="3306" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Database</label>
                <input name="database" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">User</label>
                <input name="username" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Password</label>
                <input name="password" type="password" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="md:col-span-2 flex gap-3 items-center">
                <button type="button" id="test-db" class="px-4 py-2 rounded bg-slate-700 hover:bg-slate-600 text-sm">Test connection</button>
                <button type="submit" class="px-4 py-2 rounded bg-emerald-600 hover:bg-emerald-500 text-sm">Save</button>
                <span id="db-status" class="text-sm"></span>
            </div>
        </form>
    </section>

    <section class="bg-slate-900/70 border border-slate-800 rounded-xl p-6 space-y-3">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold">3. Migrate & Seed</h2>
            @if(session('migrated'))
                <span class="text-emerald-400 text-sm">Done</span>
            @endif
        </div>
        <form action="{{ route('install.migrate') }}" method="post">
            @csrf
            <p class="text-sm text-slate-400">Runs migrations and seeds roles, settings, default admin.</p>
            <button class="mt-2 px-4 py-2 rounded bg-indigo-600 hover:bg-indigo-500 text-sm">Run migrations</button>
        </form>
    </section>

    <section class="bg-slate-900/70 border border-slate-800 rounded-xl p-6 space-y-4">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold">4. App Settings</h2>
            @if(session('settings_saved'))
                <span class="text-emerald-400 text-sm">Saved</span>
            @endif
        </div>
        <form action="{{ route('install.settings') }}" method="post" class="grid md:grid-cols-2 gap-4">
            @csrf
            <div class="space-y-1">
                <label class="text-sm text-slate-400">App Name</label>
                <input name="app_name" value="{{ config('app.name') }}" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">App URL</label>
                <input name="app_url" value="{{ config('app.url') }}" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Timezone</label>
                <input name="timezone" value="{{ config('app.timezone') }}" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Currency</label>
                <input name="currency" value="USD" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Mail Host (optional)</label>
                <input name="mail_host" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="space-y-1">
                <label class="text-sm text-slate-400">Mail User (optional)</label>
                <input name="mail_username" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2" />
            </div>
            <div class="md:col-span-2">
                <button class="px-4 py-2 rounded bg-emerald-600 hover:bg-emerald-500 text-sm">Save settings</button>
            </div>
        </form>
    </section>

    <section class="bg-slate-900/70 border border-slate-800 rounded-xl p-6 space-y-4">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold">5. Payment Gateways</h2>
            @if(session('gateways_saved'))
                <span class="text-emerald-400 text-sm">Saved</span>
            @endif
        </div>
        <form action="{{ route('install.gateways') }}" method="post" class="space-y-3">
            @csrf
            @foreach(['stripe','paypal','paystack'] as $gateway)
                <div class="p-4 rounded-lg bg-slate-800/50 space-y-2">
                    <div class="flex items-center justify-between">
                        <p class="font-semibold capitalize">{{ $gateway }}</p>
                        <label class="text-sm flex items-center gap-2">
                            <span>Enable</span>
                            <input type="checkbox" name="gateways[{{ $gateway }}][enabled]" value="1" class="w-4 h-4 accent-emerald-500">
                        </label>
                    </div>
                    <div class="grid md:grid-cols-3 gap-3">
                        <input type="hidden" name="gateways[{{ $gateway }}][name]" value="{{ $gateway }}">
                        <div>
                            <label class="text-xs text-slate-400">Mode</label>
                            <input name="gateways[{{ $gateway }}][mode]" value="test" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2 text-sm" />
                        </div>
                        <div>
                            <label class="text-xs text-slate-400">Public/Client Key</label>
                            <input name="gateways[{{ $gateway }}][credentials][public]" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2 text-sm" />
                        </div>
                        <div>
                            <label class="text-xs text-slate-400">Secret</label>
                            <input name="gateways[{{ $gateway }}][credentials][secret]" class="w-full bg-slate-800 border border-slate-700 rounded px-3 py-2 text-sm" />
                        </div>
                    </div>
                </div>
            @endforeach
            <button class="px-4 py-2 rounded bg-emerald-600 hover:bg-emerald-500 text-sm">Save gateways</button>
        </form>
    </section>

    <section class="bg-slate-900/70 border border-slate-800 rounded-xl p-6">
        <h2 class="text-xl font-semibold mb-2">6. Finish</h2>
        <form action="{{ route('install.finish') }}" method="post" class="space-y-2">
            @csrf
            <p class="text-sm text-slate-300">Locks the installer and redirects to login. Default admin: admin@example.com / password.</p>
            <button class="px-4 py-2 rounded bg-emerald-600 hover:bg-emerald-500 text-sm">Finish</button>
        </form>
    </section>
</div>

<script>
    document.getElementById('test-db')?.addEventListener('click', async () => {
        const form = document.getElementById('db-form');
        const data = Object.fromEntries(new FormData(form).entries());
        const res = await fetch('{{ route('install.database.test') }}', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        });
        const el = document.getElementById('db-status');
        if (res.ok) {
            el.textContent = 'Connection OK';
            el.className = 'text-emerald-400 text-sm';
        } else {
            const message = await res.text();
            el.textContent = 'Connection failed: ' + message;
            el.className = 'text-rose-400 text-sm';
        }
    });
</script>
</body>
</html>
