@props(['booking'])
<div class="space-y-2 text-sm text-gray-700">
    <p class="font-semibold">Status History</p>
    <div class="space-y-1">
        @foreach($booking->statusHistory()->latest()->take(5)->get() as $history)
            <div class="flex justify-between">
                <span>{{ $history->from_status }} → {{ $history->to_status }}</span>
                <span class="text-gray-500">{{ $history->created_at->diffForHumans() }}</span>
            </div>
        @endforeach
        @foreach($booking->disputes as $dispute)
            <div class="flex justify-between">
                <span>Dispute: {{ $dispute->status }}</span>
                <span class="text-gray-500">{{ optional($dispute->opened_at)->diffForHumans() }}</span>
            </div>
            @foreach($dispute->events()->latest()->take(3)->get() as $event)
                <div class="flex justify-between ml-4">
                    <span>{{ $event->action }} - {{ $event->notes }}</span>
                    <span class="text-gray-500">{{ $event->created_at->diffForHumans() }}</span>
                </div>
            @endforeach
        @endforeach
    </div>
</div>
