<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Customer Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="font-semibold mb-4">Your Bookings</h3>
                    <div class="space-y-2">
                        @forelse($bookings as $booking)
                            <div class="flex justify-between border rounded-lg p-3 items-center">
                                <div>
                                    <p class="font-semibold">{{ $booking->service?->title }}</p>
                                    <p class="text-sm text-gray-600">Status: {{ $booking->status }}</p>
                                    <x-dashboard.timeline :booking="$booking"/>
                                    @if(data_get($booking->meta, 'proposed_start'))
                                        <p class="text-xs text-amber-600 mt-1">Provider proposed: {{ \Illuminate\Support\Carbon::parse(data_get($booking->meta,'proposed_start'))->format('M d, H:i') }}</p>
                                        <div class="flex gap-2 mt-2">
                                            <form method="POST" action="{{ route('bookings.proposal.accept', $booking) }}">
                                                @csrf
                                                <button class="text-xs text-emerald-600">Accept</button>
                                            </form>
                                            <form method="POST" action="{{ route('bookings.proposal.decline', $booking) }}">
                                                @csrf
                                                <button class="text-xs text-rose-600">Decline</button>
                                            </form>
                                        </div>
                                    @endif
                                </div>
                                <div class="text-sm text-gray-600 text-right">
                                    <p>${{ number_format($booking->amount, 2) }} {{ $booking->currency }}</p>
                                    <p>{{ optional($booking->scheduled_start)->format('M d, H:i') }}</p>
                                    <div class="mt-2 flex gap-2 justify-end">
                                        <a href="{{ route('bookings.messages', $booking) }}" class="text-indigo-600 text-xs">Messages</a>
                                        <form method="POST" action="{{ route('bookings.cancel', $booking) }}">
                                            @csrf
                                            <button class="text-xs text-rose-600">Cancel</button>
                                        </form>
                                        <form method="POST" action="{{ route('bookings.disputes.store', $booking) }}">
                                            @csrf
                                            <input type="hidden" name="reason" value="Issue">
                                            <button class="text-xs text-amber-600">Dispute</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <p class="text-gray-500">No bookings yet.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
