<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Reschedule Booking #'.$booking->id) }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white p-6 rounded-lg shadow space-y-4">
                <p class="text-sm text-gray-600">Choose a new time slot.</p>
                <form action="{{ route('bookings.reschedule', $booking) }}" method="POST" class="space-y-3">
                    @csrf
                    <label class="text-sm text-gray-600">New start</label>
                    <input type="datetime-local" name="slot_start" class="border rounded px-3 py-2 w-full" required>
                    <button class="px-4 py-2 bg-indigo-600 text-white rounded">Request reschedule</button>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
