<?php

namespace Database\Factories;

use App\Models\Service;
use App\Models\ServiceCategory;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends Factory<Service>
 */
class ServiceFactory extends Factory
{
    protected $model = Service::class;

    public function definition(): array
    {
        $title = $this->faker->sentence(3);

        return [
            'user_id' => User::factory(),
            'service_category_id' => ServiceCategory::factory(),
            'title' => $title,
            'slug' => Str::slug($title).'-'.Str::random(5),
            'description' => $this->faker->paragraph(),
            'delivery_mode' => 'online',
            'booking_mode' => 'instant',
            'scheduling_type' => 'fixed_datetime',
            'duration_minutes' => 60,
            'buffer_before_minutes' => 15,
            'buffer_after_minutes' => 15,
            'lead_time_minutes' => 0,
            'cancellation_policy' => 'moderate',
            'currency' => 'USD',
            'base_price' => 100,
            'capacity' => 1,
            'status' => 'published',
        ];
    }
}
