<?php

namespace App\Policies;

use App\Models\Service;
use App\Models\User;

class ServicePolicy
{
    public function view(User $user, Service $service): bool
    {
        return true;
    }

    public function update(User $user, Service $service): bool
    {
        return $user->hasRole('provider') && $service->user_id === $user->id || $user->hasRole('admin');
    }

    public function delete(User $user, Service $service): bool
    {
        return $this->update($user, $service);
    }

    public function create(User $user): bool
    {
        return $user->hasRole('provider') || $user->hasRole('admin');
    }
}
