<?php

namespace App\Notifications;

use App\Models\Dispute;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DisputeOpened extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public Dispute $dispute)
    {
    }

    public function via(object $notifiable): array
    {
        return ['mail', 'database', \App\Notifications\Channels\SmsChannel::class];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Dispute opened for booking '.$this->dispute->booking_id)
            ->markdown('mail.dispute_opened', [
                'dispute' => $this->dispute,
                'url' => url('/provider'),
            ]);
    }

    public function toArray(object $notifiable): array
    {
        return [
            'dispute_id' => $this->dispute->id,
            'booking_id' => $this->dispute->booking_id,
            'reason' => $this->dispute->reason,
        ];
    }

    public function toSms(object $notifiable): string
    {
        return "Dispute opened on booking #{$this->dispute->booking_id}: {$this->dispute->reason}";
    }
}
