<?php

namespace App\Notifications;

use App\Models\Booking;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class BookingStatusChanged extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public Booking $booking, public string $from, public string $to)
    {
    }

    public function via(object $notifiable): array
    {
        return ['mail', 'database', \App\Notifications\Channels\SmsChannel::class];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Booking status updated')
            ->markdown('mail.booking_status', [
                'booking' => $this->booking,
                'from' => $this->from,
                'to' => $this->to,
                'url' => url('/customer'),
            ]);
    }

    public function toArray(object $notifiable): array
    {
        return [
            'booking_id' => $this->booking->id,
            'from' => $this->from,
            'to' => $this->to,
        ];
    }

    public function toSms(object $notifiable): string
    {
        return "Booking #{$this->booking->id} changed from {$this->from} to {$this->to}.";
    }
}
