<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'service_category_id',
        'title',
        'slug',
        'description',
        'delivery_mode',
        'booking_mode',
        'scheduling_type',
        'duration_minutes',
        'buffer_before_minutes',
        'buffer_after_minutes',
        'lead_time_minutes',
        'cancellation_policy',
        'currency',
        'base_price',
        'capacity',
        'location',
        'service_area',
        'media',
        'add_ons',
        'approval_timeout_hours',
        'auto_complete_hours',
        'dispute_window_hours',
        'status',
        'meta',
    ];

    protected $casts = [
        'service_area' => 'array',
        'media' => 'array',
        'add_ons' => 'array',
        'meta' => 'array',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(ServiceCategory::class, 'service_category_id');
    }

    public function provider(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function bookings(): HasMany
    {
        return $this->hasMany(Booking::class);
    }

    public function availabilityRules(): HasMany
    {
        return $this->hasMany(AvailabilityRule::class);
    }

    public function availabilityExceptions(): HasMany
    {
        return $this->hasMany(AvailabilityException::class);
    }
}
