<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DisputeEvent extends Model
{
    use HasFactory;

    protected $fillable = [
        'dispute_id',
        'user_id',
        'action',
        'notes',
        'metadata',
        'evidence_paths',
    ];

    protected $casts = [
        'metadata' => 'array',
        'evidence_paths' => 'array',
    ];

    public function dispute(): BelongsTo
    {
        return $this->belongsTo(Dispute::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
