<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'service_id',
        'customer_id',
        'provider_id',
        'status',
        'booking_mode',
        'scheduling_type',
        'delivery_mode',
        'scheduled_start',
        'scheduled_end',
        'timezone',
        'amount',
        'escrow_amount',
        'currency',
        'payment_gateway_id',
        'meta',
        'notes',
        'provider_notes',
        'approval_expires_at',
        'auto_complete_at',
        'dispute_deadline_at',
    ];

    protected $casts = [
        'meta' => 'array',
        'scheduled_start' => 'datetime',
        'scheduled_end' => 'datetime',
        'approval_expires_at' => 'datetime',
        'auto_complete_at' => 'datetime',
        'dispute_deadline_at' => 'datetime',
    ];

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function provider(): BelongsTo
    {
        return $this->belongsTo(User::class, 'provider_id');
    }

    public function gateway(): BelongsTo
    {
        return $this->belongsTo(PaymentGateway::class, 'payment_gateway_id');
    }

    public function slots(): HasMany
    {
        return $this->hasMany(BookingSlot::class);
    }

    public function payments(): HasMany
    {
        return $this->hasMany(Payment::class);
    }

    public function ledgerEntries(): HasMany
    {
        return $this->hasMany(EscrowLedger::class);
    }

    public function disputes(): HasMany
    {
        return $this->hasMany(Dispute::class);
    }

    public function messages(): HasMany
    {
        return $this->hasMany(Message::class);
    }

    public function statusHistory(): HasMany
    {
        return $this->hasMany(BookingStatusHistory::class);
    }
}
