<?php

namespace App\Http\Controllers;

use App\Models\Booking;
use App\Models\Service;
use Illuminate\Support\Facades\Auth;

class ProviderDashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $services = Service::where('user_id', $user->id)->latest()->take(5)->get();
        $bookings = Booking::where('provider_id', $user->id)->latest()->take(5)->get();

        return view('dashboard.provider', compact('services', 'bookings'));
    }
}
