<?php

namespace App\Http\Controllers;

use App\Services\PaymentService;
use Illuminate\Http\Request;

class PaymentWebhookController extends Controller
{
    public function __construct(private PaymentService $payments)
    {
    }

    public function handle(string $gateway, Request $request)
    {
        $payment = $this->payments->handleWebhook($gateway, $request);

        return response()->json(['status' => 'ok', 'payment_id' => $payment?->id]);
    }
}
