<?php

namespace App\Http\Controllers;

use App\Models\Booking;
use Illuminate\Support\Facades\Auth;

class CustomerDashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $bookings = Booking::with('service')->where('customer_id', $user->id)->latest()->take(5)->get();

        return view('dashboard.customer', compact('bookings'));
    }
}
