<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Services\AvailabilityService;
use Carbon\Carbon;
use Illuminate\Http\Request;

class AvailabilityController extends Controller
{
    public function __construct(private AvailabilityService $availability)
    {
    }

    public function slots(Service $service, Request $request)
    {
        $from = Carbon::parse($request->input('from', now()));
        $to = Carbon::parse($request->input('to', now()->addWeek()));

        $slots = $this->availability->getSlots($service, $from, $to);

        return response()->json([
            'service_id' => $service->id,
            'from' => $from,
            'to' => $to,
            'slots' => $slots->map(fn ($slot) => [
                'start' => $slot['start']->toIso8601String(),
                'end' => $slot['end']->toIso8601String(),
                'timezone' => $slot['timezone'],
            ]),
        ]);
    }
}
