<?php

namespace App\Filament\Widgets;

use App\Models\Booking;
use Filament\Widgets\ChartWidget;

class BookingStatusBreakdown extends ChartWidget
{
    protected ?string $heading = 'Booking Status Mix';

    protected static ?int $sort = 2;

    protected function getType(): string
    {
        return 'doughnut';
    }

    protected function getData(): array
    {
        $data = Booking::selectRaw('status, COUNT(*) as total')
            ->groupBy('status')
            ->pluck('total', 'status');

        $labels = $data->keys()->map(fn ($status) => ucfirst(str_replace('_', ' ', $status)))->toArray();
        $values = $data->values()->toArray();
        $palette = [
            '#10b981',
            '#3b82f6',
            '#f59e0b',
            '#ef4444',
            '#a855f7',
            '#6366f1',
            '#14b8a6',
            '#ec4899',
            '#22d3ee',
            '#f97316',
            '#4b5563',
            '#84cc16',
        ];
        $colors = collect($values)->keys()->map(fn ($i) => $palette[$i % count($palette)])->toArray();

        return [
            'datasets' => [
                [
                    'label' => 'Bookings',
                    'data' => $values,
                    'backgroundColor' => $colors,
                ],
            ],
            'labels' => $labels,
        ];
    }
}
