<?php

namespace App\Filament\Resources\DisputeResource\Pages;

use App\Filament\Resources\DisputeResource;
use Filament\Actions;
use Filament\Forms;
use Filament\Resources\Pages\ViewRecord;

class ViewDispute extends ViewRecord
{
    protected static string $resource = DisputeResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('note')
                ->label('Add resolution note')
                ->icon('heroicon-o-pencil')
                ->form([
                    Forms\Components\Textarea::make('resolution')->label('Notes')->required(),
                ])
                ->action(function (array $data) {
                    $this->record->update(['resolution' => $data['resolution']]);
                    $this->record->events()->create([
                        'user_id' => auth()->id(),
                        'action' => 'note',
                        'notes' => $data['resolution'],
                    ]);
                }),
            Actions\Action::make('resolve')
                ->label('Resolve')
                ->requiresConfirmation()
                ->action(function () {
                    $this->record->update(['status' => 'resolved', 'resolved_at' => now(), 'resolution' => 'Resolved in admin']);
                    $this->record->events()->create([
                        'user_id' => auth()->id(),
                        'action' => 'resolved',
                        'notes' => 'Resolved in admin',
                    ]);
                }),
            Actions\Action::make('reject')
                ->label('Reject')
                ->color('danger')
                ->requiresConfirmation()
                ->action(function () {
                    $this->record->update(['status' => 'rejected', 'resolved_at' => now(), 'resolution' => 'Rejected']);
                    $this->record->events()->create([
                        'user_id' => auth()->id(),
                        'action' => 'rejected',
                        'notes' => 'Rejected',
                    ]);
                }),
        ];
    }
}
